"He Turns Towards the Light" by "Jimmy Maher and Victor Gijsbers"

Dark cell is a room. "Utter darkness surrounds you."



Chapter - Acting in darkness

Section - Examining

Instead of examining:
	say "There is not enough light here for you to make out anything.".


Section - Looking

[We redirect "look" and "l" to a new not-looking action. The looking action itself is very complex and we want to keep using it.]

Understand the command "look" as something new. Understand the command "l" as something new.

Not-looking is an action applying to nothing. Understand "look" and "l" as not-looking.

Instead of not-looking:
	say "The darkness is total; but you might be able to [italic type]feel[roman type] your way around."


Section - Feeling around and room description

Feeling around is an action applying to nothing.
	
Understand "feel" and "feel around" as feeling around.

[The lines below are an alternative to "produce a room description with going spacing conventions", an alternative we need to get rid of one nasty single line of whitespace.]

Before feeling around:
	give the feeling around room description.

To give the feeling around room description:
	(- AbbreviatedRoomDescription(); -).

[Here we do some magic. Both feeling around and getting a room description start the looking action, but we want only part of the looking rulebook to fire in each case. Getting a room description fives you the name + the description, but not the objects; feeling around gives you only the objects.]

The room description heading rule is not listed in the carry out looking rules.
The room description body text rule is not listed in the carry out looking rules.
The room description paragraphs about objects rule is not listed in the carry out looking rules.

Carry out looking rule:
	if the room-describing action is the looking action:
		follow the real-looking rules;
	otherwise:
		follow the feel-looking rules.

The real-looking rules are a rulebook.

The room description heading rule is listed first in the real-looking rules.
The room description body text rule is listed in the real-looking rules.

The feel-looking rules are a rulebook.

The room description paragraphs about objects rule is listed in the feel-looking rules.


Section - Standard replies

Instead of tasting:
	say "[The noun] has only the faint taste of dust.".



Chapter - Naming


Naming it to is an action applying to one visible thing and one topic.

Check naming it to: 
	if the noun is not an Object listed in the Table of Invisible Objects, say "No need to put a name on [italic type]that[roman type]." instead.
Check naming it to: 
	repeat through the Table of Invisible Objects:
		if the topic understood matches the text "[Name entry]" or the topic understood matches the text "[printed name of Object Entry]":
			say "You recall that you've already mentally labelled something else by a name too close to that." instead.
Carry out naming it to: choose row with an Object of the noun in the Table of Invisible Objects; change the Name entry to the topic understood; replace the regular expression "\p$" in the Name entry with "".
Report naming it to: choose row with an Object of the noun in the Table of Invisible Objects; say "You decide to refer to [the noun] as '[Name entry]' from now on."
Understand "name [something] [text]" as naming it to.
Understand "label [something] [text]" as naming it to.

Rule for printing the name of something (called the target):
	if we are not naming and the target is an Object listed in the Table of Invisible Objects:
		choose row with an Object of the target in the Table of Invisible Objects;
		say "[Name entry]";
	otherwise:
		say "[printed name of the target]".

Table of Invisible Objects
Object					Name (indexed text)
light bulb				"small, round object"

After reading a command:
	let C be indexed text;
	let C be the player's command;
	repeat through the Table of Invisible Objects:
		if the Object entry is visible and C matches the text " [Name entry]":
			replace the text " [Name entry]" in C with " [printed name of the Object entry]";
			replace the regular expression "\.$" in C with " ";
	change the text of the player's command to C.






Chapter - New actions


Section - Following up and down

[This action created for the seat belt. I'll also implement it for walls; for everything else just a standard response.]

Following up is an action applying to one thing. Understand "follow [something] up" and "follow up [something]" as following up.

Carry out following up:
	say "You feel nothing unexpected near the top of [the noun].".

Instead of following up the player:
	say "Hair. What else?".


Following down is an action applying to one thing. Understand "follow [something] down" and "follow down [something]" as following down.




Chapter - Sample objects



The light bulb is in dark cell. The printed name of the light bulb is "small, round object". Understand "small", "round" and "object" as the light bulb.

The smaller cylinder is part of the light bulb. Understand "smaller" and "cylinder" and "groove" as the smaller cylinder.

Instead of touching the light bulb:
	say "The larger part of the object is round and somewhat cool to the touch--perhaps glass or ceramic. A smaller cylinder is attached to it.".
	
Instead of touching the smaller cylinder:
	say "It feels metallic. A small groove spirals along the side.".



Part - Strapped in a chair

The chair is in the cell. The chair is an enterable supporter. The player is on the chair.

Instead of touching the chair:
	if the player is on the chair:
		say "The chair is soft and comfortable, covered with what feels like real leather. It extends all the way to the back of your head.";
	otherwise:
		say "It's a soft chair, covered with what feels like real leather. It rests on the ground with four metal legs.".

Instead of taking the chair:
	say "It is much too heavy.".
	
Instead of tasting the chair:
	if the belt boolean is true:
		say "Even if you turn your head and your chest as far as possible, your tongue still cannot reach the chair.";
	otherwise:
		say "Leather, definitely.".


The belt boolean is a truth state that varies. The belt boolean is true. [The belt boolean is true iff the seat belt is worn.]

The restraining belt is part of the chair.

The getting off the chair counter is a number that varies. The getting off the chair counter is 0. [We want to track this to print the appropriate comments from the loudspeaker.]

Check getting off the chair:
	if the belt boolean is true, say "You try to stand, but a belt across your chest restrains you." instead.

Instead of touching the restraining belt:
	if the belt boolean is true:
		say "A band of smooth, cool textile runs across your chest. You could follow the belt up or down.";
	otherwise:
		say "Smooth, cool textile. There is a metal part halfway that can be used to click the belt back into place.".

Instead of following down the restraining belt:
	if the belt boolean is true:
		say "Your hand glides downwards along the belt until it touches a broad plastic button.";
		now the broad plastic button is part of the chair;
	otherwise:
		try touching the restraining belt instead.

Instead of following up the restraining belt:
	if the belt boolean is true:
		say "Your hand glides upwards, following the belt over your shoulder to where it disappears into the chair. There is nothing there.";
	otherwise:
		try touching the restraining belt instead.		

The broad plastic button is a thing.

Instead of touching the broad plastic button:
	say "You might be able to press it.".
	
Instead of pushing the broad plastic button for the first time:
	say "As soon as you start pressing the button, a loud metallic voice comes from the ceiling.[paragraph break][italic type]'Please do not press the button. We thank you in advance for your cooperation.'[line break][roman type]".

Instead of pushing the broad plastic button for the second time:
	say "Again your fingers apply a little pressure to the button, and again the voice from the ceiling speaks.[paragraph break][italic type]'Please. This button is not for pressing.'[line break][roman type]".
	
Instead of pushing the broad plastic button for the third time:
	say "".
	


Part - Replacing some standard rules

Section - You can (also) see

The you-can-also-see rule is not listed in any rulebook.
The new you-can-also-see rule is listed after the interesting locale paragraphs rule in the for printing the locale description rulebook.

For printing the locale description (this is the new you-can-also-see rule):
	let the domain be the parameter-object;
	let the mentionable count be 0;
	repeat with item running through things:
		now the item is not marked for listing;
	repeat through the Table of Locale Priorities:
		if the locale description priority entry is greater than 0,
			now the notable-object entry is marked for listing;
		increase the mentionable count by 1;
	if the mentionable count is greater than 0:
		repeat with item running through things:
			if the item is mentioned:
				now the item is not marked for listing;
		begin the listing nondescript items activity;
		if the number of marked for listing things is 0:
			abandon the listing nondescript items activity;
		otherwise:
			if handling the listing nondescript items activity:
				if the domain is a room:
					if the domain is the location, say "As you grope about, your hand ";
					otherwise say "In [the domain] you ";
				otherwise if the domain is a supporter:
					say "On [the domain] you ";
				otherwise if the domain is an animal:
					say "On [the domain] you ";
				otherwise:
					say "In [the domain] you ";
				say "[if the locale paragraph count is greater than 0]also [end if]touches ";
				let the common holder be nothing;
				let contents form of list be true;
				repeat with list item running through marked for listing things:
					if the holder of the list item is not the common holder:
						if the common holder is nothing,
							now the common holder is the holder of the list item;
						otherwise now contents form of list is false;
					if the list item is mentioned, now the list item is not marked for listing;
				filter list recursion to unmentioned things;
				if contents form of list is true and the common holder is not nothing,
					list the contents of the common holder, as a sentence, including contents, giving brief inventory information, tersely, not listing concealed items, listing marked items only;
				otherwise say "[a list of marked for listing things including contents]";
[				if the domain is the location, say " here";]
				say ".[paragraph break]";
				unfilter list recursion;
			end the listing nondescript items activity;
	continue the activity.



Section - You can't see any such thing

Rule for printing a parser error when the parser error is can't see any such thing:
    say "You can't feel any such thing." instead. 

